#!/bin/bash

usage="
Usage:   isMemPro_scampi.sh fasta-seq-file
  check whether proteins are TM protein or not using scampi
Options:
  -o <file>         : set outfile
  -scampipath <str> : set the scampi installed path, default=/scampi
  -modhmmpath <str> : set the modhmm installed pathpath, default=/bin
  -h|--help         : print this help message and exit
Created 2011-03-08, updated 2011-09-01, Nanjiang
"
function PrintHelp()
{
    echo "$usage"
}
function IsProgExist()#{{{
# usage: IsProgExist prog
# prog can be both with or without absolute path
{
    type -P $1 &>/dev/null || { echo "The program \"$1\" is required but it's not installed. Aborting $0" >&2; exit 1; }
}
#}}}
function IsPathExist()#{{{
# supply the effective path of the program 
{
    if ! test -d $1; then
        echo "directory $1 does not exist, exit $0" >&2
        exit
    fi
}
#}}}
function IsMemPro_Scampi()
{
    local fastafile=$1
    local tmpdir=$(mktemp -d /tmp/tmpdir.isMemPro_scampi.XXXXXXX) || { echo "Can not create tmpdir, exit $0" >&2; exit; }
#    $binpath/mySCAMPI_run.pl  $fastafile -outpath $tmpdir >/dev/null 2>&1
    $binpath/mySCAMPI_TMfilter.pl  -scampipath $scampi_dir -modhmmpath $modhmm_bin $fastafile -outpath $tmpdir >/dev/null 2>&1
    basename=`basename $fastafile`
    xmlfile=$tmpdir/$basename.xml.res
    /usr/bin/awk -F: '{if($1=="SeqID"){printf ("%s\t", $2)}else if ($1=="IsTMProtein"){print $2}}' $xmlfile > $outfile
    /bin/rm -rf $tmpdir
}

if [ $# -lt 1 ]; then
    PrintHelp
    exit
fi

binpath=`dirname $0`
isQuiet=false
outfile=/dev/stdout
fastafile=
scampi_dir=$SCAMPI_DIR
modhmm_bin=$MODHMM_BIN
if [ "$scampi_dir" == "" ]; then 
    scampi_dir=/data3/share/scampi
fi
if [ "$modhmm_bin" == "" ]; then 
    modhmm_bin=/data3/share/modhmm/bin
fi

isNonOptionArg=false
while [ "$1" != "" ]; do
    if [ "$isNonOptionArg" == "true" ]; then 
        fastafile=$1
        isNonOptionArg=false
    elif [ "$1" == "--" ]; then
        isNonOptionArg=true
    elif [ "${1:0:1}" == "-" ]; then
        case $1 in
            -h | --help) PrintHelp; exit;;
            -o|--o) outfile=$2;shift;;
            -q) isQuiet=true;;
            -scampipath|--scampipath) scampi_dir=$2;shift;;
            -modhmmpath|--modhmmpath) modhmm_bin=$2;shift;;
            -*) echo "Error! Wrong argument: $1"; exit;;
        esac
    else
        fastafile=$1
    fi
    shift
done
IsProgExist $binpath/mySCAMPI_TMfilter.pl
IsProgExist /usr/bin/awk
IsProgExist /bin/rm
IsPathExist $scampi_dir
IsPathExist $modhmm_bin
IsProgExist $modhmm_bin/modhmms_scampi

if [ "$fastafile" == "" ]; then
    echo "Error, input not set! Exit $0" >&2
    exit
fi

if [ "$fastafile" != ""  ]; then
    if [ -f "$fastafile" ] ; then
        IsMemPro_Scampi $fastafile
    else 
        echo "seqfile $fastafile does not exist" >&2
    fi
fi

