#!/usr/bin/python
import sys,os,re;

def GetSeqIDFromAnnotation(line):
# get the ID from the annotation line of the fasta  file
# updated 2010-08-24
    seqID = "";
    line = line.lstrip('>').split()[0]; #get the first word after '>'
    if line and line.find('|') >= 0:# if the annotation line has |, e.g. >sp|P0AE31|ARTM_ECOL6 Arginine ABC transporter permease
        strs = line.split("|");
        if (strs[0] == "sp" or strs[0] == "lcl" or strs[0] == "tr") : seqID = strs[1];
        else                 : seqID = strs[0];
    else:
        seqID=line;
    return seqID;

def ReadSingleFasta(inFile):
    seqID="";
    aaSeq="";
    annotation="";
    try:
        fpin = open(inFile, "r");
        lines = fpin.readlines();
        fpin.close();
        for line in lines:
            if line[0] == ">":
                seqID = GetSeqIDFromAnnotation(line);
                annotation = line.lstrip(">").strip();
            else:
                aaSeq+=line.strip();
    except:
        print >> sys.stderr, "Except for the input file ", inFile, "in the function ReadSingleFasta";
    return (seqID, annotation, aaSeq);

