#!/usr/bin/perl -w

use POSIX;

(($infile,$prefix,$number_of_files) = @ARGV) || die("Syntax: fasta_split.pl fasta_file prefix number_of_files\n");
for ($i=0;$i<length($number_of_files-1);$i++) {
    $nr .= "0";
}
$number_of_sequences=`cat $infile|grep ">"|wc -l`;
$sequences_per_file=ceil($number_of_sequences/$number_of_files);

$seq_nr=0;
open(IN,$ARGV[0]) || die("Could not open input file: $infile\n");
open(OUT,">".$prefix.$nr) || die;
while($name=<IN>) {
    $sequence="";
    while($seq=<IN>) {
	($seq =~ /^\s*$/) && next;
	($seq =~ /^>/) && (seek(IN,-1*length($seq),1) && last || die);
	$sequence .= $seq;
    }
    print OUT $name.$sequence;
    $seq_nr++;
    if ($seq_nr == $sequences_per_file) {
	$seq_nr=0;
	close(OUT);
	$nr++;
	open(OUT,">".$prefix.$nr) || die;
    }
}
close(OUT);
close(IN);
